<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-07 12:05
 */
interface CheckcontrollerDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Checkcontroller 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param checkcontroller primary key
 	 */
	public function delete($checkControllerid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Checkcontroller checkcontroller
 	 */
	public function insert($checkcontroller);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Checkcontroller checkcontroller
 	 */
	public function update($checkcontroller);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCheckid($value);

	public function queryByControllerid($value);

	public function queryByType($value);


	public function deleteByCheckid($value);

	public function deleteByControllerid($value);

	public function deleteByType($value);


}
?>